new const NINTENDOMOD_MARIO_PLUGIN[] = "Nintendo Mod X Mario"
new const NINTENDOMOD_MARIO_VERSION[] = "2.1"
new const NINTENDOMOD_MARIO_AUTHOR[] = "Soloist/Mephisto"

/*
	1st Passive: High Jump
		* Lower gravity as level increases.
	2nd Passive: Paralysis
		* Possible chance that enemies get paralysed when shooting or touching you.
	Skill 1: Super Jump
		* Has the ability to muti-jump.
	Skill 2: Hammer Time
		* Knife does more damage, also has hammer model for knife.
	Skill 3: Doctor Mario
		* Constantly giving out pills healing yourself and everyone around you every few second.
	PowerUp: Star
		* Like the Star from Super Mario, when the player touches an enemy he is killed.

	Based on Soloist's original source code Mario v1.2, updated by Mephisto
	Version 2.1
	Last Updated On 06/09/09

	*************************************************************************************

	Changelog
		Version 2.1
			* native error get_weaponname fixed in Mario_StarReset
		Version 2.0.1
			* plugin title changed
		Version 2.0
			* healing skill fixed, now heals to a player's full max health
			* skills have four levels now, PowerUp has three levels
			* lvl cap increased to 15
			* 2nd passive skill added
		Version 1.2
			* When star is on Mario is now Godlike
		Version 1.1
			* Fixed Doctor Mario not healing teammates
		Version 1.0
			* Release of the plugin
*/

#include <amxmodx>
#include <fakemeta>
#include <nintendomod>

new const Float:MARIO_HIGHJUMPGRAV[11] = {775.0, 750.0, 725.0, 700.0, 675.0, 650.0, 625.0, 600.0, 500.0, 400.0, 350.0};
new const Float:MARIO_STARTIME[3] = {4.0, 6.0, 7.0};
new const Float:MARIO_STARSPEED[3] = {375.0, 390.0, 400.0};
new const Float:MARIO_PARALYSISPROB_ONATT[5] = {0.06, 0.07, 0.08, 0.09, 0.10};	// on attack
new const Float:MARIO_PARALYSISPROB_ONTCH[5] = {0.60, 0.65, 0.70, 0.75, 0.80};	// on touch
new const MARIO_SUPERJUMPTIMES[4] = {1, 2, 3, 4};
new const MARIO_HAMMERTIMEDMG[4] = {25, 50, 75, 150}
new const Float:MARIO_DOCTERMARIOHEALTH[4] = {1.0, 2.0, 3.0, 4.0}

new charName[] = "Mario";
new passiveName[] = "High Jump";
new passive2Name[] = "Paralysis";
new skill1Name[] = "Super Jump";
new skill2Name[] = "Hammer Time";
new skill3Name[] = "Doctor Mario";
new powerupName[] = "Star";
new initName[] = "Mario_Init";
new keyDownName[] = "Mario_Star";

new passiveHelp[] = "Lower gravity as level increases.";
new passive2Help[] = "Possible chance that enemies get paralysed when shooting or touching you.";
new skill1Help[] = "Has the ability to muti-jump.";
new skill2Help[] = "Knife does more damage, also has hammer model for knife.";
new skill3Help[] = "Constantly giving out pills healing yourself and everyone around you every few second.";
new powerupHelp[] = "Like the Star from Super Mario, when the player touches an enemy he is killed.";

new PlayerLevel[33];
new PlayerSkill1[33];
new PlayerSkill2[33];
new PlayerSkill3[33];
new PlayerPowerUp[33];

new knife_sounds[9][] =
{
    "weapons/knife_deploy1.wav",
    "weapons/knife_hit1.wav",
    "weapons/knife_hit2.wav",
    "weapons/knife_hit3.wav",
    "weapons/knife_hit4.wav",
    "weapons/knife_hitwall1.wav",
    "weapons/knife_slash1.wav",
    "weapons/knife_slash2.wav",
    "weapons/knife_stab.wav"
};

new jumpNum[33] = 0;
new bool:doJump[33] = false;
new bool:Star[33];
new bool:Paralysed[33] = false;

new healthSpr, paralysisSpr;

public plugin_init()
{
	if(is_plugin_loaded("Nintendo Mod Xtended") == -1)
	{
		server_print("**********************************");
		server_print("*** Nintendo Mod is not loaded ***");
		server_print("**********************************");
		pause("ae");
		return;
	}

	register_plugin(NINTENDOMOD_MARIO_PLUGIN, NINTENDOMOD_MARIO_VERSION, NINTENDOMOD_MARIO_AUTHOR);

	register_cvar("NintendoMod_Mario_Version", NINTENDOMOD_MARIO_VERSION, FCVAR_SERVER|FCVAR_SPONLY);

	register_event("ResetHUD", "ResetHUD", "b");

	register_event("Damage", "Mario_Damage", "b", "2!0");
	register_event("CurWeapon", "Mario_HammerTime","be","1=1");

	register_forward(FM_PlayerPreThink, "Mario_SuperJumpPre");
	register_forward(FM_PlayerPostThink, "Mario_SuperJumpPost");
	register_forward(FM_EmitSound, "Mario_HammerSound");
	register_forward(FM_Touch, "Mario_StarTouch");

	Nintendo_RegisterChar(charName, passiveName, passive2Name, skill1Name, skill2Name, skill3Name, powerupName, initName);
	Nintendo_RegisterHelp(charName, passiveHelp, passive2Help, skill1Help, skill2Help, skill3Help, powerupHelp);
	Nintendo_RegisterKeyDown(charName, keyDownName);

	register_srvcmd(initName, initName);
	register_srvcmd(keyDownName, keyDownName);
}

public plugin_precache()
{
	engfunc(EngFunc_PrecacheSound, "nintendomod/mario_hammer.wav");
	engfunc(EngFunc_PrecacheSound, "nintendomod/mario_hammertime.wav");
	engfunc(EngFunc_PrecacheModel, "models/nintendomod/mario_knife.mdl");
	healthSpr = engfunc(EngFunc_PrecacheModel, "sprites/nintendomod/mario_health.spr");
	paralysisSpr = engfunc(EngFunc_PrecacheModel, "sprites/nintendomod/mario_paralysis.spr");
}

public client_connect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);

	return PLUGIN_CONTINUE;
}

public client_disconnect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);
	remove_task(id);

	return PLUGIN_CONTINUE;
}

public InitPlayer(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerLevel[id] = 0;
	PlayerSkill1[id] = 0;
	PlayerSkill2[id] = 0;
	PlayerSkill3[id] = 0;
	PlayerPowerUp[id] = 0;

	return PLUGIN_CONTINUE;
}

public Mario_Init()
{
	new temp[33];
	read_argv(1, temp, 32);
	new id = str_to_num(temp);

	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	read_argv(2, temp, 32);
	new index  = str_to_num(temp);

	if(index == 0)
	{
		read_argv(3, temp, 32);
		new level = str_to_num(temp);
		read_argv(4, temp, 32);
		new skill1 = str_to_num(temp);
		read_argv(5, temp, 32);
		new skill2 = str_to_num(temp);
		read_argv(6, temp, 32);
		new skill3 = str_to_num(temp);
		read_argv(7, temp, 32);
		new powerup = str_to_num(temp);

		PlayerLevel[id] = level;
		PlayerSkill1[id] = skill1;
		PlayerSkill2[id] = skill2;
		PlayerSkill3[id] = skill3;
		PlayerPowerUp[id] = powerup;
	}
	else
	{
		read_argv(3, temp, 32);
		new value = str_to_num(temp);

		switch(index)
		{
			case 1: PlayerLevel[id] = value;
			case 2: PlayerSkill1[id] = value;
			case 3: PlayerSkill2[id] = value;
			case 4: PlayerSkill3[id] = value;
			case 5: PlayerPowerUp[id] = value;
		}
	}

	ResetHUD(id);

	return PLUGIN_CONTINUE;
}

public ResetHUD(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	Star[id] = false;

	Mario_HighJump(id);
	// remove Mario's healing tasks before
	remove_task(id);
	Mario_DocterMario(id);

	return PLUGIN_CONTINUE;
}

public Mario_Damage(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new weapon, bodypart, attacker = get_user_attacker(id, weapon, bodypart)
	new headshot = bodypart == 1 ? 1 : 0

	if(Nintendo_HasChar(id, charName) && PlayerLevel[id] > 10 && Nintendo_IsValidPlayer(attacker))
	{
		new Float:randomnumber = random_float(0.0, 1.0);
		new Float:prob = MARIO_PARALYSISPROB_ONATT[PlayerLevel[id] - 11];
		if(pev(id, pev_maxspeed) <= 1.0)
			prob *= 5.0;

		if(Nintendo_TeamKill(id, attacker) && randomnumber <= prob)
		{
			new parm[2];
			parm[0] = attacker;
			parm[1] = pev(attacker, pev_maxspeed);
			Mario_Paralysis(parm);
		}
	}

	if(!Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	else if(PlayerSkill2[attacker] > 0)
	{
		if(weapon == CSW_KNIFE)
			Mario_HammerDmg(id, attacker, headshot);
	}

	return PLUGIN_CONTINUE;
}

public Mario_HighJump(id) // 1st Passive
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerLevel[id] > 10)
		Nintendo_SetGravity(id, MARIO_HIGHJUMPGRAV[10]);
	else
		Nintendo_SetGravity(id, MARIO_HIGHJUMPGRAV[PlayerLevel[id]]);

	return PLUGIN_CONTINUE;
}

public Mario_Paralysis(parm[]) // 2nd Passive
{
	new id = parm[0];
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new Float:velocity[3];
	velocity[0] = 0.0;
	velocity[1] = 0.0;
	velocity[2] = 10.0;
	Paralysed[id] = true;

	engclient_cmd(id, "weapon_knife");
	set_pev(id, pev_velocity, velocity);
	Nintendo_SetSpeed(id, 1.0);
	Mario_ParalysisSprite(id);
	Nintendo_ScreenFade(id, (1<<0), (1<<10), (1<<12), 255, 255, 0, 200);
	message_begin(MSG_ONE, get_user_msgid("ScreenShake"), {0,0,0}, id);
	write_short(1<<14);
	write_short(1<<14);
	write_short(1<<14);
	message_end();

	set_task(1.0, "Mario_ParalysisReset", 0, parm, 2);

	return PLUGIN_CONTINUE;
}

public Mario_SuperJumpPre(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName)  || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerSkill1[id] > 0)
	{
		new newButton = pev(id, pev_button);
		new oldButton = pev(id, pev_oldbuttons)
		if((newButton & IN_JUMP) && !(pev(id, pev_flags) &FL_ONGROUND) && !(oldButton & IN_JUMP))
		{
			if(jumpNum[id] < MARIO_SUPERJUMPTIMES[PlayerSkill1[id]-1])
			{
				doJump[id] = true
				jumpNum[id]++
				return PLUGIN_CONTINUE
			}
		}
		if((newButton & IN_JUMP) && (pev(id, pev_flags) &FL_ONGROUND))
		{
			jumpNum[id] = 0
			return PLUGIN_CONTINUE
		}
	}
	return PLUGIN_CONTINUE
}

public Mario_SuperJumpPost(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName)  || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerSkill1[id] > 0)
	{
		if(doJump[id] == true)
		{
			new Float:velocity[3]
			pev(id, pev_velocity, velocity)
			velocity[2] = random_float(265.0, 285.0)
			set_pev(id, pev_velocity, velocity)
			doJump[id] = false
			return PLUGIN_CONTINUE
		}
	}
	return PLUGIN_CONTINUE
}

public Mario_HammerTime(id) // Skill 2
{
	if(Nintendo_Active() && Nintendo_IsValidPlayer(id) && Paralysed[id])
	{
		new Float:velocity[3];
		velocity[0] = 0.0;
		velocity[1] = 0.0;
		velocity[2] = 10.0;

		engclient_cmd(id, "weapon_knife");
		set_pev(id, pev_velocity, velocity);
		Nintendo_SetSpeed(id, 1.0);
	}

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerSkill2[id] > 0)
	{
		new clip, ammo, weapon = get_user_weapon(id, clip, ammo)

		if(weapon == CSW_KNIFE)
			set_pev(id, pev_viewmodel, engfunc(EngFunc_AllocString, "models/nintendomod/mario_knife.mdl"))
	}

	if(Star[id] && PlayerPowerUp[id] >= 1)
	{
		engclient_cmd(id, "weapon_knife");
		Nintendo_SetSpeed(id, MARIO_STARSPEED[PlayerPowerUp[id] - 1]);
	}

	return PLUGIN_CONTINUE;
}

public Mario_HammerSound(entity, channel, const sound[])
{
	if(!Nintendo_Active() || !Nintendo_HasChar(entity, charName) || !Nintendo_IsValidPlayer(entity))
		return PLUGIN_HANDLED;

	if(PlayerSkill2[entity] > 0)
	{
		if(pev_valid(entity) && Nintendo_IsValidPlayer(entity))
		{
			if(equal(sound, knife_sounds[0]))
			{
				emit_sound(entity, channel, "nintendomod/mario_hammertime.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
				return FMRES_SUPERCEDE;
			}

			for(new i = 1; i < 9; i++)
			{
				if(equal(sound, knife_sounds[i]))
				{
					emit_sound(entity, channel, "nintendomod/mario_hammer.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
					return FMRES_SUPERCEDE;
				}
			}
		}
	}
	return FMRES_IGNORED;
}

public Mario_HammerDmg(id, attacker, headshot) // Skill 2
{
	if(!Nintendo_Active() || !Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(attacker)|| !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerSkill2[attacker] > 0)
	{
		if(Nintendo_TeamKill(id, attacker))
			Nintendo_ExtraDamage(attacker, id, MARIO_HAMMERTIMEDMG[PlayerSkill2[attacker] - 1], "Hammer Time", headshot);
	}

	return PLUGIN_CONTINUE;
}
public Mario_DocterMario(id) // Skill 3
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id) || !is_user_alive(id))
		return PLUGIN_HANDLED;

	if(PlayerSkill3[id] > 0)
	{
		new Float:newHealth, curHealth;

		curHealth = pev(id, pev_health);

		if(curHealth < pev(id, pev_max_health))
		{
			newHealth = curHealth + MARIO_DOCTERMARIOHEALTH[PlayerSkill3[id] - 1];
			if(newHealth > float(pev(id, pev_max_health))) newHealth = float(pev(id, pev_max_health));

			Nintendo_SetHealth(id, newHealth, false);
			Mario_DoctorMarioSprite(id);
		}

		new players[32], num, player;
		get_players(players, num);
		for(new i = 0; i <= num; i++)
		{
			player = players[i];
			if(Nintendo_IsValidPlayer(player))
			{
				if((get_user_team(id) == get_user_team(player)) && (id != player))
				{
					new healer[3], healed[3];

					get_user_origin(id, healer);
					get_user_origin(player, healed);
					if(get_distance(healer, healed) <= 500)
					{
						curHealth = pev(player, pev_health);

						if(curHealth < pev(id, pev_max_health))
						{
							newHealth = curHealth + MARIO_DOCTERMARIOHEALTH[PlayerSkill3[id] - 1];
							if(newHealth > float(pev(player, pev_max_health))) newHealth = float(pev(player, pev_max_health));
							Nintendo_SetHealth(player, newHealth, false);
							Mario_DoctorMarioSprite(player);
						}
					}
				}
			}
		}

		set_task(2.0,"Mario_DocterMario", id)
	}

	return PLUGIN_CONTINUE;
}

public Mario_DoctorMarioSprite(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(124)
	write_byte(id)
	write_coord(50)
	write_short(healthSpr)
	write_short(3)
	message_end()

	return PLUGIN_CONTINUE;
}

public Mario_ParalysisSprite(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(124)
	write_byte(id)
	write_coord(50)
	write_short(paralysisSpr)
	write_short(16)
	message_end()

	return PLUGIN_CONTINUE;
}

public Mario_Star()
{
	new temp[6]
	read_argv(1, temp, 5)
	new id = str_to_num(temp)

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerPowerUp[id] >= 1)
	{
		Nintendo_PowerUpUsed(id, 1, 30);

		Star[id] = true;

		Nintendo_SetGlow(id, kRenderFxGlowShell, 255, 255, 0, kRenderNormal, 25);
		Nintendo_SetSpeed(id, MARIO_STARSPEED[PlayerPowerUp[id] - 1]);
		engclient_cmd(id, "weapon_knife");
		set_pev(id, pev_takedamage, 0.0);

		new parm[2];
		parm[0] = id;
		parm[1] = pev(id, pev_maxspeed);
		set_task(MARIO_STARTIME[PlayerPowerUp[id] - 1], "Mario_StarReset", 0, parm, 2);
	}

	return PLUGIN_CONTINUE;
}

public Mario_StarTouch(victim, attacker)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(victim) || !Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	if(Star[attacker])
	{
		if(Nintendo_TeamKill(victim, attacker))
			Nintendo_ExtraDamage(attacker, victim, 200, "Star", 0);
	}
	else if(PlayerLevel[attacker] > 10)
	{
		new Float:randomnumber = random_float(0.0, 1.0);
		if(Nintendo_TeamKill(victim, attacker) && randomnumber <= MARIO_PARALYSISPROB_ONTCH[PlayerLevel[attacker] - 11])
		{
			new parm[2];
			parm[0] = victim;
			parm[1] = pev(victim, pev_maxspeed);
			Nintendo_SetSpeed(victim, 1.0);
			Mario_Paralysis(parm);
		}
	}

	return PLUGIN_CONTINUE;
}

public Mario_ParalysisReset(parm[])
{
	new id = parm[0];
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new Float:old_speed = float(parm[1]);
	Nintendo_SetSpeed(id, old_speed);
	Paralysed[id] = false;

	return PLUGIN_CONTINUE;
}

public Mario_StarReset(parm[])
{
	new id = parm[0];
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	Star[id] = false;
	Nintendo_SetGlow(id);
	set_pev(id, pev_takedamage, 2.0);
	Nintendo_StatusHUD(id, "[Mario] Star has ended", 1);

	new Float:old_speed = float(parm[1]);
	Nintendo_SetSpeed(id, old_speed);

	new weapons[32], numWeapons, weaponname[33];
	get_user_weapons(id, weapons, numWeapons);
	for(new i=0; i < numWeapons; i++)
	{
		if(weapons[i])
		{
			get_weaponname(weapons[i], weaponname, 32);
			engclient_cmd(id, weaponname);
			break;
		}
	}

	return PLUGIN_CONTINUE;
}
